%define module_name Log-Any-Adapter-Dupstd
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Log/Any.pm) perl(Module/Build/Tiny.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/PerlTidy.pm) perl(base.pm) perl(utf8/all.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: Cunning adapter for logging to a duplicate of
Group: Development/Perl
License: perl
URL: https://github.com/ivanych/Log-Any-Adapter-Dupstd

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/I/IV/IVANYCH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Adapters Dupstd are intended to log messages into duplicates of standard
descriptors STDOUT and STDERR.

Logging into a duplicate of standard descriptor might be needed in special
occasions when you need to redefine or even close standard descriptor but you
want to continue displaying messages wherever they are displayed by a standard
descriptor. 

For instance, your script types something in STDERR, and you want to redirect
that message into a file. If you redirect STDERR into a file, warnings `warn'
and even exceptions `die' will be redirected there as well. But that is not
always convenient. In many cases it is more convenient to display warnings and
exceptions on the screen.

    # Redirect STDERR into a file
    open(STDERR, '>', 'stderr.txt');

    # This message will go to the file, not on the screen (you want this)
    print STDERR 'Some message';

    # This warning will go to the file too (and that is what you don't want)
    warn('Warning!');

You can try to display warning or exception on the screen by yourself using
adapter Stderr from the distributive Log::Any. But adapter Stderr types message
on STDERR so the message will anyway be in the file and not on the screen.

    # Adapter Stderr
    use Log::Any::Adapter ('Stderr');

    # Redirect STDERR into a file
    open(STDERR, '>', 'stderr.txt')

    # This message will go to the file, not on the screen (you want this)
    print STDERR 'Some message';

    # Oops, warning will go to the file (again it's not what you expected)
    $log->warning('Warning!')

You can display message on the screen using adapter Stdout, which is also in the
distributive Log::Any. Warning will be displayed on the screen as expected, but
that will be "not real" warning because it will be displayed through STDOUT.
That warning will be impossible to filter in the shell.

    # That won't be working!
    $ script.pl 2> error.log

That is the situation when you need adapter Dupstd. Warnings and exceptions sent
using these adapters will be "real". They can be filtered in the shell just as
if they would have been sent to usual STDERR. 

    # Adapter Duperr (definitely PRIOR TO redirecting STDERR)
    use Log::Any::Adapter ('Duperr');

    # Redirect STDERR into a file
    open(STDERR, '>', 'stderr.txt')

    # This message will go to the file, not on the screen (you want this)
    print STDERR 'Some message';

    # Warning will be displayed on the screen (that is what you want)
    $log->warning('Warning!')
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes
%perl_vendor_privlib/L*

%changelog
