%define module_name Log-Any-Adapter-Journal
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Method/Modifiers.pm) perl(Log/Any.pm) perl(Log/Any/Adapter/Screen.pm) perl(Module/Build/Tiny.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0
Release: alt1
Summary: Adapter for Log::Any that outputs with a priority prefix that systemd's journal can parse
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MG/MGRIMES/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
When sending log messages to systemd's journal, the priority can be set by
prefixing the message with the priority (as a number) in angled brackets.
This adapter will format the Log::Any manpage messages to accomodate the systemd's log
parser.

By default, systemd will parse the output from commands run as systemd
services/units for the priority prefix (both STDOUT and STDERR). Users can
also pipe output through the `systemd-cat' command to enable parsing of
priority for scripts.

This adapter is based on the the Log::Any::Adapter::Screen manpage, and accepts the same
optional settings. We assume you want color output when running interactively
and the priority prefix otherwise.  More precisely, the priority prefix will be
added when `! -t STDIN' or `!!use_color'.  See the Log::Any::Adapter::Screen manpage
for more information on the various options.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/L*

%changelog
