# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(Log/Dispatch.pm) perl(Log/Dispatch/File.pm) perl(Log/Log4perl.pm) perl(Log/Log4perl/DateFormat.pm) perl(Test.pm) perl(Test/Fork.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Time/HiRes.pm)
# END SourceDeps(oneline)
%define module_version 1.09
%define module_name Log-Dispatch-File-Rolling
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.09
Release: alt1
Summary: Object for logging to date/time/pid stamped files
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JA/JACOB/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module subclasses Log::Dispatch::File for logging to date/time
stamped files. See the Log::Dispatch::File manpage for instructions on usage.
This module differs only on the following three points:

=over 4

=item fork()-safe

This module will close and re-open the logfile after a fork.

=item multitasking-safe

This module uses flock() to lock the file while writing to it.

=item stamped filenames

This module supports a special tag in the filename that will expand to
the current date/time/pid.

It is the same tag Log::Log4perl::Layout::PatternLayout uses, see
the Log::Log4perl::Layout::PatternLayout manpage, chapter "Fine-tune the date".
In short: Include a "%%d{...}" in the filename where "..." is a format
string according to the SimpleDateFormat in the Java World
(http://java.sun.com/j2se/1.3/docs/api/java/text/SimpleDateFormat.html).
See also the Log::Log4perl::DateFormat manpage for information about further
restrictions.

In addition to the format provided by Log::Log4perl::DateFormat this
module also supports '$' for inserting the PID. Repeat the character to
define how many character wide the field should be. This should not be
needed regularly as this module also supports logfile sharing between
processes, but if you've got a high load on your logfile or a system
that doesn't support flock()...

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/L*

%changelog
