%define module_name Log-File-Rolling
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(Test/Fork.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Time/Piece.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.101
Release: alt2
Summary: Log to date/time-stamped files
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/F/FR/FRACTAL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module was forked from the the Log::Dispatch::File::Rolling manpage to add the symlink feature and fix a few other minor issues (see the `Changes' file for details).

Similar to the original, this module should also have these properties:

=over 4

=item fork()-safe

This module will close and re-open the logfile after a fork.

=item multitasking-safe

This module uses flock() to lock the file while writing to it.

=item stamped filenames

This module's "stamped" filenames are rendered with the Time::Piece manpage's `strftime' function. By default it uses `gmtime' for UTC timestamps, but this can be changed by passing `localtime' into the constructor's `timezone' parameter (see the synopsis).

NOTE: Because of a caching optimisation, files should not be rotated more often than once per second.

=item current symlinks

If you pass in `current_symlink' to the constructor, it will create a symlink at your provided filename. This symlink will always link to the most recent log file. You can then use `tail -F' to monitor an application's logs with no interruptions even when the filename rolls over.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/L*

%changelog
