# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Module/Load/Conditional.pm) perl(Moose.pm) perl(Moose/Exporter.pm) perl(MooseX/Aliases.pm) perl(MooseX/Storage.pm) perl(Term/ANSIColor.pm) perl(Test/More.pm) perl(Test/Output.pm) perl(Test/Trap.pm) perl(constant.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Log-MixedColor
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.000
Release: alt1
Summary: Outputs messages in multiple colors
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MQ/MQTECH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Output log messages in color while emphasizing parts of the message in a different color.
Although colour codes witin a message string can be done manually, this module is providing a 
simplified approach to colour logging hopefully saving time and code
(and colour codes can also be inserted manually if required - i.e. they won't be stripped).

    use Log::MixedColor;
    my $log = Log::MixedColor->new;

    $log->verbose(1);
    $log->info_msg( "This is a " . $log->quote('general info') . " message." );

    $log->debug(1);
    $log->debug_msg( "This is a " . $log->q('debug') . " message" );

There are four types of messages:

=over

=item * `info_msg' (or `info') - displayed when debug or verbose are turned on

=item * `debug_msg' (or `dmsg') - displayed when debug is turned on

=item * `err_msg' (or `err') - displayed all the time on STDERR

=item * `fatal_msg' (or `fatal') - displayed all the time on STDERR and will cause the script to exit

=back

The `debug' and `verbose' methods are intended so that the script utilising this module can
pass the command line option values specifying whether to operate the script logging in verbose or debug mode.

    use Getopt::Std;
    use Log::MixedColor;

    our( $opt_v, $opt_d );
    getopts('vd');

    my $log = Log::MixedColor->new( verbose => $opt_v, debug => $opt_d );

    $log->info_msg( "This is a " . $log->quote('general info') . " message." );
    $log->debug_msg( "This is a " . $log->q('debug') . " message" );

The debug log messages will only display when the script is run with `-d' and the verbose messages will
be display when the script is run with `-d' or `-v'.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.mkdn README README.md Changes LICENSE
%perl_vendor_privlib/L*

%changelog
