%define module_name Log-Report-Template
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Dancer2/Core/Role/Template.pm) perl(Dancer2/Core/Types.pm) perl(Dancer2/FileUtils.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Find.pm) perl(Log/Report.pm) perl(Log/Report/Lexicon.pm) perl(Log/Report/Util.pm) perl(Moo.pm) perl(Scalar/Util.pm) perl(String/Print.pm) perl(Template.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.02
Release: alt1
Summary: template toolkit with translations
Group: Development/Perl
License: perl
URL: http://perl.overmeer.net/CPAN/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MARKOV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module extends Template, which is the core of Template Toolkit.
The main addition is support for translations via the translation
framework offered by Log::Report.

You add translations to a template system, by adding calls to some
translation function (by default called 'loc()') to your template text.
That function will perform dark magic to collect the translation from
translation tables, and fill in values.  For instance:

  <div>Price: [%% price %%]</div>          # no translation
  <div>[%% loc("Price: {price}") %%]</div> # translation optional

It's quite a lot of work to make your templates translatable.
Please read the the DETAILS entry elsewhere in this document section before you start using this module.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README ChangeLog README.md
%perl_vendor_privlib/L*
%perl_vendor_privlib/D*

%changelog
