%define module_name Log-ger-Like-Log4perl
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Log/ger.pm) perl(Log/ger/Output.pm) perl(Log/ger/Plugin.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(vars.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: Mimic Log::Log4perl
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Log-ger-Like-Log4perl

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module does the following to mimic the Log::Log4perl manpage to a certain extent:

=over

=item * Log4perl-like formatting

 $log->warn("a", "b", sub { "c", "d" })

will format the message as "abcd".

=item * Uppercase subroutine names

This module provides uppercase subroutine names: TRACE, DEBUG, INFO, ERROR,
WARN, FATAL like what you get when you "use Log::Log4perl ':easy'" instead of
the Log::ger default log_trace(), log_debug(), log_info(), log_warn(),
log_error(), log_fatal().

It also provides LOGDIE and LOGWARN.

=item * Export level constants

It exports the log level values: `$TRACE', `$DEBUG', `$INFO', `$WARN',
`$ERROR', `$FATAL'.

=item * Additional logging methods

It provides additional log methods: log(), logdie(), logwarn(), error_warn(),
error_die(), logcarp(), logcluck(), logcroak(), logconfess() like you would get
in Log4perl.

=back

=for Pod::Coverage ^(get_logger)$
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/L*

%changelog
