# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(FileHandle.pm) perl(Object/InsideOut.pm) perl(Test/Harness.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Time/HiRes.pm)
# END SourceDeps(oneline)
%define module_version 2.0
%define module_name Logger-Simple
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.0
Release: alt1
Summary: Implementation of the Simran-Log-Log and Simran-Error-Error modules
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/T/TS/TSTANLEY/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
=over 5

=item new

`my $log=Logger::Simple->new(LOG=>"/tmp/logfile");'

The new method creates the Logger::Simple object as an inside-out object. The Log parameter
is a mandatory one that must be passed to the object at creation, or the object will fail.
Upon creation, this method will also call the open_log method which opens the log file.

=item write 

`$log->write("This is an error message");'

This method will write a message to the logfile, and will update the internal
HISTORY array.

=item retrieve_history

`my @history = $log->retrieve_history;'
`my $msg = $log->retrieve_history;'

When called in scalar context, it will return the last message written to the
HISTORY array. When called in a list context, it will return the entire HISTORY
array

=item clear_history

`$log->clear_history;'

This method will clear the internal HISTORY array

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/L*

%changelog
