%define module_version 3.001003
%define module_name MAD-Loader
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Const/Fast.pm) perl(English.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Moo.pm) perl(Pod/Coverage/TrustPod.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 3.001003
Release: alt1
Summary: A tiny module loader
Group: Development/Perl
License: perl
URL: http://blabos.org

Source0: http://cpan.org.ua/authors/id/B/BL/BLABOS/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
MAD::loader is a module loader and object builder for situations when you
want several modules being loaded dynamically.

For each module loaded this way an builder method may be called with
or without arguments. You may also control where the loader will search for
modules, you may prefix the module names with a custom namespace and you
may change how it will behave on getting errors.

    ## Procedural interface, for handling one module each time
    use MAD::Loader qw{ fqn load_module build_object };
    
    my $fqn = fqn( 'My::Module', 'My::Prefix' );
    # $fqn is 'My::Prefix::My::Module'
    
    my $module = load_module(
        module      => 'Bar',
        prefix      => 'Foo',
        inc         => [ 'my/local/lib' ],
        on_error    => \&error_handler,
    );
    # $module is 'Foo::Bar' if Foo::Bar was successfully loaded
    # error_handler() will be called in case of error
    
    my $object = build_object(
        module      => 'Foo::Bar',
        builder     => 'new',
        args        => [ 123, 456 ],
        on_error    => \&error_handler,
    );
    # Foo::Bar must be already loaded
    # $object = Foo::Bar->new( 123, 456 );
    
    ## OO interface, for handling many modules each time
    use MAD::Loader;

    my $loader = MAD::Loader->new(
        prefix      => 'Foo',
        set_inc     => [ 'my/module/dir' ],
        builder     => 'new',
        args        => [ 123, 456 ],
        on_error    => \&error_handler,
    );
    
    my $loaded = $loader->load( qw{ Bar Etc 123 } );
    # Same as:
    use Foo::Bar;
    use Foo::Etc;
    use Foo::123;
    
    my $built = $loader->build( qw{ Foo::Bar Foo::Etc Foo::123 } );
    # Same as:
    my $built = {
        Foo::Bar => Foo::Bar->new( 123, 456 ),
        Foo::Etc => Foo::Etc->new( 123, 456 ),
        Foo::123 => Foo::123->new( 123, 456 ),
    }
    
    my $built = $loader->load_and_build( qw{ Bar Etc 123 } );
    # Same as:
    use Foo::Bar;
    use Foo::Etc;
    use Foo::123;
    
    my $built = {
        Foo::Bar => Foo::Bar->new( 123, 456 ),
        Foo::Etc => Foo::Etc->new( 123, 456 ),
        Foo::123 => Foo::123->new( 123, 456 ),
    }



%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/M*

%changelog
