%define module_name MARC-Convert-Wikidata-Object
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/pod2pdf.pm) perl(Business/ISBN.pm) perl(CPAN.pm) perl(Capture/Tiny.pm) perl(Error/Pure.pm) perl(ExtUtils/CBuilder.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/All.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(List/Util.pm) perl(Mo.pm) perl(Mo/utils.pm) perl(Mo/utils/Array.pm) perl(Mo/utils/Date.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Pod/Html.pm) perl(Pod/Markdown.pm) perl(Readonly.pm) perl(Test/More.pm) perl(Test/NoWarnings.pm) perl(Unicode/UTF8.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.14
Release: alt1
Summary: Bibliographic Wikidata object defined by MARC record.
Group: Development/Perl
License: bsd
URL: https://github.com/michal-josef-spacek/MARC-Convert-Wikidata-Object

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SK/SKIM/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use MARC::Convert::Wikidata::Object;

 my $obj = MARC::Convert::Wikidata::Object->new(%%params);
 my $authors_ar = $obj->authors;
 my $authors_of_afterword_ar = $obj->authors_of_afterword;
 my $authors_of_introduction_ar = $obj->authors_of_introduction;
 my $ccnb = $obj->ccnb;
 my $compilers = $obj->compilers;
 my $cover = $obj->cover;
 my $directors_ar = $obj->directors;
 my $dml = $obj->dml;
 my $edition_number = $obj->edition_number;
 my $editors_ar = $obj->editors;
 my $end_time = $obj->end_time;
 my $full_name = $obj->full_name;
 my $illustrators_ar = $obj->illustrators;
 my $isbns_ar = $obj->isbns;
 my $issn = $obj->issn;
 my $kramerius_ar = $obj->krameriuses;
 my $languages_ar = $obj->languages;
 my $narrators_ar = $obj->narrators;
 my $number_of_pages = $obj->number_of_pages;
 my $oclc = $obj->oclc;
 my $photographers_ar = $obj->photographers;
 my $publication_date = $obj->publication_date;
 my $publishers_ar = $obj->publishers;
 my $series_ar = $obj->series;
 my $start_time = $obj->start_time;
 my $subtitles_ar = $obj->subtitles;
 my $title = $obj->title;
 my $translators_ar = $obj->translators;

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README examples
%perl_vendor_privlib/M*

%changelog
