%define module_name MCE-Shared
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Errno.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Handle.pm) perl(MCE.pm) perl(PDL.pm) perl(POSIX.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Storable.pm) perl(Test/More.pm) perl(Time/HiRes.pm) perl(base.pm) perl(bytes.pm) perl(constant.pm) perl(open.pm) perl(overload.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.893
Release: alt1
Summary: MCE extension for sharing data supporting threads and processes
Group: Development/Perl
License: perl
URL: https://github.com/marioroy/mce-shared

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MARIOROY/%{module_name}-%{version}.tar.gz
BuildArch: noarch
Requires: perl(Sereal/Decoder.pm) perl(Sereal/Encoder.pm) perl(IO/FDPass.pm)

%description
This module provides data sharing capabilities for the MCE manpage supporting
threads and processes. the MCE::Hobo manpage, included with the distribution,
provides threads-like parallelization for running code asynchronously.

`MCE::Shared' enables extra functionality on systems with `IO::FDPass'.
Without it, MCE::Shared is unable to send file descriptors to the
shared-manager process for `queue', `condvar', and possibly `handle'.

IO::FDPass is explicitly added as dependency to this rpm package.

The following is a suggestion for systems without `IO::FDPass'.
This restriction applies to `queue', `condvar', and `handle' only.

   use MCE::Shared;

   # Construct shared queue(s) and condvar(s) first.
   # These contain GLOB handles - freezing not allowed.

   my $q1  = MCE::Shared->queue();
   my $q2  = MCE::Shared->queue();

   my $cv1 = MCE::Shared->condvar();
   my $cv2 = MCE::Shared->condvar();

   # Start the shared-manager manually.

   MCE::Shared->start();

   # The shared-manager process knows of STDOUT, STDERR, STDIN

   my $fh1 = MCE::Shared->handle(">>", \*STDOUT);  # ok
   my $fh2 = MCE::Shared->handle("<", "/path/to/sequence.fasta");  # ok
   my $h1  = MCE::Shared->hash();

Otherwise, sharing is immediate and not delayed with `IO::FDPass'. It is not
necessary to share `queue' and `condvar' first or worry about starting the
shared-manager process.

   use MCE::Shared;

   my $h1 = MCE::Shared->hash();    # shares immediately
   my $q1 = MCE::Shared->queue();   # IO::FDPass sends file descriptors
   my $cv = MCE::Shared->condvar(); # IO::FDPass sends file descriptors
   my $h2 = MCE::Shared->ordhash();

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md Copying
%perl_vendor_privlib/M*

%changelog
