# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Term/ReadKey.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    MIDI-ALSA
%define upstream_version 1.22

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt7_13

Summary:    ALSA library access for Perl, plus some interface functions
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/MIDI-ALSA
Source0:    https://cpan.metacpan.org/authors/id/P/PJ/PJB/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl-devel
BuildRequires: libalsa-devel
Source44: import.info
%description
This module offers a Perl interface to the ALSA library. It is a
call-compatible translation into Perl of the Lua module midialsa
which is in turn based on the Python modules alsaseq.py and alsamidi.py
by Patricio Paez.

It also offers some functions to translate events from and to the event
format used in Sean Burke's MIDI-Perl module.

Nothing is exported by default, but all the functions and constants can be
exported, e.g.: use MIDI::ALSA(client, connectfrom, connectto, id, input,
output); use MIDI::ALSA(':CONSTS');

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor OPTIMIZE="$RPM_OPT_FLAGS"
%make_build

%install
make pure_install PERL_INSTALL_ROOT=%{buildroot}
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} ';'
find $RPM_BUILD_ROOT -type f -name '*.bs' -empty -exec rm -f {} ';'
chmod -R u+w $RPM_BUILD_ROOT/*

%files
%doc Changes META.yml  README examples
%{perl_vendor_archlib}/MIDI/ALSA.pm
%{perl_vendor_archlib}/auto/MIDI/ALSA/ALSA.so


%changelog
