%define module_name MIDI-Bassline-Walk
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dumper/Compact.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(List/SomeUtils.pm) perl(List/Util.pm) perl(Moo.pm) perl(Music/Chord/Note.pm) perl(Music/Note.pm) perl(Music/PitchNum.pm) perl(Music/Scales.pm) perl(Music/VoiceGen.pm) perl(Pod/Coverage/TrustPod.pm) perl(Pod/Wordlist.pm) perl(Set/Array.pm) perl(Test/EOL.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Spelling.pm) perl(Test/Synopsis.pm) perl(constant.pm) perl(namespace/clean.pm) perl(strict.pm) perl(strictures.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0601
Release: alt1
Summary: Generate walking basslines
Group: Development/Perl
License: artistic_2
URL: https://github.com/ology/MIDI-Bassline-Walk

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GE/GENE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`MIDI::Bassline::Walk' generates randomized, walking basslines.

The "formula" implemented by this module is basically, "play any notes
of the chord-root scale, plus the notes of the chord that may differ,
minus the notes those replaced."

The logic (and music theory) implemented here, can generate some sour
notes.  This is an approximate composition tool, and not a drop-in
bass player.  Import rendered MIDI into a DAW and alter things until
they are suitable.

The chords recognized by this module, are those known to
the Music::Chord::Note manpage.  Please see the source of that module for the
list.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README README.md
%perl_vendor_privlib/M*

%changelog
