%define module_name MIDI-Chord-Guitar
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/ShareDir.pm) perl(File/ShareDir/Install.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(List/Util.pm) perl(Moo.pm) perl(Music/Note.pm) perl(Music/PitchNum.pm) perl(Pod/Coverage/TrustPod.pm) perl(Pod/Wordlist.pm) perl(Test/EOL.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Spelling.pm) perl(Test/Synopsis.pm) perl(Text/CSV_XS.pm) perl(namespace/clean.pm) perl(strict.pm) perl(strictures.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0706
Release: alt1
Summary: MIDI pitches for guitar chord voicings
Group: Development/Perl
License: perl
URL: https://github.com/ology/MIDI-Chord-Guitar

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GE/GENE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`MIDI::Chord::Guitar' provides MIDI pitches for common chord voicings
of an `E A D G B E' tuned guitar.

=for html <p>Here is a handy diagram of ISO MIDI pitches laid out on a guitar neck:</p>
<img src="https://raw.githubusercontent.com/ology/MIDI-Chord-Guitar/main/guitar-position-midi-octaves.png">
<p>And here is a companion diagram of MIDI pitch numbers laid out on a guitar neck:</p>
<img src="https://raw.githubusercontent.com/ology/MIDI-Chord-Guitar/main/guitar-position-midi-numbers.png">

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE README
%perl_vendor_privlib/M*
%perl_vendor_privlib/auto/*

%changelog
