%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(DynaLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name MIDI-Music
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt7
Summary: Perl interface to /dev/music.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SE/SETHJ/%module_name-%module_version.tar.gz

%description
MIDI::Music is a high-level interface to /dev/music, and is designed to
function on any *NIX system supported by Open Sound System v.3.8 or higher.

Playback through internal and external MIDI devices is supported, as is
the "recording" of events from an external device. Additional goals in
designing MIDI::Music were:

=over 4

=item 1

to provide an API with as few methods necessary to satisfy 99%% of MIDI
programmers' purposes.

=item 2

to provide easy integration with Sean M. Burke's MIDI-Perl suite by means 
of a common event specification.

=back

There are, at present, essentially three things you can do with MIDI::Music:

=over 4

=item 1 

Play a MIDI file.

=item 2 

Play a series of events defined in an event structure, which is a LoL
as described in the the MIDI::Event manpage documentation.

=item 3

Read a series events from an external device. These events are returned as
the same type of event structure as in [2].

=back 

It is important to remember that MIDI::Music is not a "realtime" synthesizer
interface in the strictest, unbuffered sense of the term. :) Rather, a series 
of events are written to an internal buffer (in playback-related methods, 
anyway) which is flushed periodically. The "playevents" function may have, 
for example, long since returned, while the user continues to hear notes 
being played.

FWIW: The readevents() method is fast to be sure, but the time involved in 
the interpretation of data from the external synthesizer should be taken
into account. This time will of course depend on how many messages are being 
processed at any given read, the speed of the machine doing the processing, 
etc.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_archlib/M*
%perl_vendor_autolib/*

%changelog
