%define module_name MIME-Mini
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Copy.pm) perl(File/Spec.pm) perl(POSIX.pm) perl(Sys/Hostname.pm) perl(Test/Deep.pm) perl(Test/FailWarnings.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(locale.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.002
Release: alt1
Summary: Minimal code to parse/create mbox files and mail messages
Group: Development/Perl
License: perl
URL: https://metacpan.org/dist/MIME-Mini

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RA/RAFORG/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
*MIME::Mini* is a collection of functions that parse and produce mailbox
files and individual mail messages. It started out as *minimail*, a
non-module cut-and-paste version, intended to be compact enough to cut and
paste directly into perl scripts that don't want to require non-standard
perl modules. *MIME::Mini* is for people that prefer a CPAN module.

It is intended to be yet another alternative to *MIME-tools*. *MIME-tools*
does things that this code doesn't (such as uuencode and binhex decoding).
And *MIME::Mini* does things that *MIME-tools* doesn't such as reading and
writing mailbox files correctly (repairing incorrectly formatted ones along
the way), and transparently unravelling `winmail.dat' attachments (aka
*MS-TNEF*). *MIME::Mini* is much smaller (about 3%% of the size of
*MIME-tools* and the other modules it requires, and about 20%% of the size
of *MIME-Lite* (which doesn't parse)), and so takes much less time during
program start up.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/M*

%changelog
