# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(IO/Socket.pm) perl(Net/hostent.pm) perl(Mail/Audit.pm)
# END SourceDeps(oneline)
%define module_version 1.0
%define module_name Mail-Centipaid
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0
Release: alt1
Summary: Mail::Audit plugin to check for email postage
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AE/AELFAKIH/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Mail::Audit::Centipaid is an email filter that is used to detect.the precence of electronic postage. Once detected, the postage is 
checked against the receipt server of Centipaid.com to insure that the
the proper payment has been made.  

Centipaid.com can process electronic postage as low as $0.001.  
The idea of this filter came about as another method to control the growing
problem of SPAM, which was proposed by the Adaptive Mail Delivery 
Protocol (AMDP). Please refer to amdpmail.com for more info.

Mail::Audit::Centipaid can be used by individuals or companies to designate 
one or more email accounts SPAM free.  This is done by installing a .forward
for these accounts, and use the enclosed centifilter.pl program to filter out
mail that does not contain valid postage.  Only paid email will be allowed
through the filter.

Centipaid supports two types of stamps.

1. CENTIPIX stamps, which are bought by the sender and used to make payments.
   Payment processing is deducted from the payment done by the sender.

2. EZPASS stamps, which are issued by the receiver and given to individuals
   he/she wants to grant them postage-free access the email account.
  Payment processing is paid by the recepient.
           
The module can also be used in conjunction with SpamAssassin to autoamtically
reject email messages with a certain spam ranking, and to be directed to pay 
for postage. 

Other uses include the designation of postage-requiered email accounts such 
as the ones used for consulting, support, business to business, etc..

Postage paying
Paying for postage is easy, once the sender has obtained a CENTPIX from 
www.centipix.com.  The sender can re-use the same CENTIPIX in payments
for postage, online access, shopping online, etc.. until its funds are
completely used up.

Including postage in emails
The postage can be included in the BODY or HEADER of the email message.

Mail::Audit::Centipaid generate a valid payment url for postage payment.
When used, centipaid will give the payee the option to include the 
postage receipt in the body of the email by copying and pasting the
text into the body of the email message, or using the online email
interface, which includes the postage receipt in the header of the
message. Both are supported by this module.


How does it work?
Email messages are parsed for AMDP-PAYMENT-RCPT string which specifies
that the message contains an AMDP style electronic postage. Once it is
detected the receipt number is extracted, and centipaid receipt server
is contacted to get a verification that a payment has been made for the
postage rate set in the configuration.

Ideally the AMDP-PAYMENT-RCPT should reside in the header, however since
AMDP protocol is new, and email applications do not support its inclusion
in the header area of a message, the BODY of the message is searched for
the string. Please refer to amdpmail.com for information about the protocol.

If the receipt is found, and it is a valid one, check_mail() returns an
Ok code, but if the rcpt is not found, it returns an error code, and a
well formed url that is used to send to the sender to ask them to pay 
for the postage.

Please refer to centipaid.com for the most updated version of this 
module, since other methods of payment may be available.



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README example
%perl_vendor_privlib/M*

%changelog
