# BEGIN SourceDeps(oneline):
BuildRequires: perl(AnyEvent.pm) perl(AnyEvent/Handle.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/All.pm) perl(JSON/XS.pm) perl(LWP/UserAgent.pm) perl(Test/More.pm) perl(Test/Simple.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_version 0.9
%define module_name Marathon
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.9
Release: alt1
Summary: An object-oriented Mapper for the Marathon REST API
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/G/GE/GEIDIES/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module is a wrapper around the [Marathon REST API](http://mesosphere.github.io/marathon/docs/rest-api.html), so it can be used without having to write JSON by hand.

For the most common tasks, there is a helper method in the main module. Some additional metods are found in the Marathon::App etc. submodules.

To start, create a marathon object:

    my $m = Marathon->new( url => 'http://my.marathon.here:8080' );

    my $app = $m->get_app('hello-marathon');
    
    $app->instances( 23 );
    $app->update();
    print STDERR Dumper( $app->deployments );
    
    sleep 10;
    
    $app->instances( 1 );
    $app->update( {force => 'true'} ); # should work even if the scaling up is not done yet.

Please report [issues on github](https://github.com/geidies/perl-Marathon)
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/M*

%changelog
