# BEGIN SourceDeps(oneline):
BuildRequires: perl(B/Hooks/EndOfScope.pm) perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Devel/Declare.pm) perl(Exporter/Lite.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(HTML/Entities.pm) perl(Module/Build.pm) perl(String/BufferStack.pm) perl(Sub/Install.pm) perl(Test/HTML/Lint.pm) perl(Test/More.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define module_version 0.14
%define module_name Markapl
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.14
Release: alt1
Summary: Markup as Perl
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/G/GU/GUGOD/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This is a new try to use the Devel::Declare manpage to change the Perl5
language. It learns pretty much everything from the Template::Declare manpage,
and has similar interface. With only one difference: how element
attributes are defined.

In the Template::Declare manpage, it goes like:

    h1 {
        id is "title";
        outs "Hi";
    };

In here, it is:

    h1(id => "title") { "Hi" };

Or a shorthand for "id" attribute:

    h1("#title") { "Hi" };

However, there are conflict between HTML tag names and perl builtin function /
ops, and the behaviour of which cannot (and better not) be altered by Markapl:

    link map q s sub tr

To generate markup with these tags, and `"html_"' prefix to them, for instance:

    html_q { "I a quotation, but this tag is not supported by IE." }

It'll produce:

    <q>I a quotation, but this tag is not supported by IE.</q>

For tables, since there's absolutely no way to clobber "tr" in Perl
AFAIK (not without using source filter,) tr and td are both renamed
to row and cell, correspondly:

    table {
      row {
        cell { "gugod" };
        cell { "170cm" };
        cell { "100kg" };
      }
    }

It actually makes more sense. This idea is borrowed from
the Template::Declare manpage

Several helper methods are defined in the Markapl::Helpers manpage. Read the
documentation there too.

Smoe HTML5 tags allow value-less attributes like:

    <script async src="foo.js"></script>

To generate those, pass <undef> as the attribute value:

    script(src => "foo.js", async => undef);


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/M*

%changelog
