%define module_name Markdown-Table
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Moo.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Text/ASCIITable.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Create and parse tables in Markdown
Group: Development/Perl
License: artistic_2
URL: https://github.com/perlservices/Markdown-Table

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLSRVDE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
To generate a table

    use Markdown::Table;

    my $table   = Markdown::Table->new;
    my @columns = qw(Id Name Role);
    $table->set_cols( @columns );

    my @data = (
        [ 1, 'John Smith', 'Testrole' ],
        [ 2, 'Jane Smith', 'Admin' ],
    );

    $table->add_rows( @data );

    print $table->get_table;

To get tables from an existing Markdown document

    use Markdown::Table;

    my $markdown = q~
    This table shows all employees and their role.

    | Id | Name | Role |
    |---|---|---|
    | 1 | John Smith | Testrole |
    | 2 | Jane Smith | Admin |
    ~;

    my @tables = Markdown::Table->parse(
        $markdown,
    );

    print $tables[0]->get_table;

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README CONTRIBUTING.md Changes CONTRIBUTORS LICENSE
%perl_vendor_privlib/M*

%changelog
