%define module_name Masscan-Scanner
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dumper.pm) perl(Data/Validate/Domain.pm) perl(Data/Validate/IP.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(IPC/Open3.pm) perl(JSON.pm) perl(Log/Log4perl.pm) perl(Log/Log4perl/Appender/ScreenColoredLevels/UsingMyColors.pm) perl(Moose.pm) perl(MooseX/AttributeShortcuts.pm) perl(MooseX/Meta/TypeConstraint/Mooish.pm) perl(MooseX/StrictConstructor.pm) perl(MooseX/Types/Moose.pm) perl(MooseX/Types/Structured.pm) perl(Net/DNS.pm) perl(Symbol.pm) perl(Test/More.pm) perl(Try/Catch.pm) perl(namespace/autoclean.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 20200329.150259
Release: alt1
Summary: A Perl module which helps in using the masscan port scanner.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AV/AVERNA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Masscan::Scanner;

    my @hosts     = qw('::1', '127.0.0.1');
    my @ports     = qw('22', '80', '443', '1-100');
    my @arguments = qw('--banners');

    my $mas = Masscan::Scanner->new(hosts => \@hosts, ports => \@ports, arguments => \@arguments);

    # Add extra hosts or ports
    $mas->add_host('10.0.0.1');
    $mas->add_host('10.0.0.0/24');
    $mas->add_port(25);
    $mas->add_port(110);

    # Can add port ranges too
    $mas->add_port('1024-2048');
    $mas->add_port('3000-65535');

    # Can add domains but will incur a performance penalty hence IP(s) and CIDR(s) recommended.
    $mas->add_host('averna.id.au');
    $mas->add_host('duckduckgo.com');

    # It is usually required that masscan is run as a privilaged user.
    # Obviously this module can be successfully run as the root user.
    # However, if this is being run by an unprivilaged user then sudo can be enabled.
    #
    # PLEASE NOTE: This module assumes the user can run the masscan command without
    # providing their password. Usually this is achieved by permitting the user to
    # run masscan within the /etc/sudoers file like so:a
    #
    # In /etc/sudoers: user averna = (root) NOPASSWD: /usr/bin/masscan
    $mas->sudo(1);

    # Turn on verbose mode
    # Default is off
    $mas->verbose(1);

    # Add extra masscan arguments
    $mas->add_argument('--rate 100000');

    # Set the full path to masscan binary
    # Default is the module will automatically find the binary full path if it's
    # withing the users environment path.
    $mas->binary('/usr/bin/masscan');

    # Set the name servers to be used for DNS resolution
    # Default is to use a list of public DNS servers
    $mas->name_servers(['192.168.0.100', '192.168.0.101']);

    # Will initiate the masscan.
    # If the scan is successful returns True otherwise returns False.
    my $scan = $mas->scan;

    # Returns the scan results
    my $res = $mas->scan_results if ($scan);

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README README.md LICENSE
%perl_vendor_privlib/M*

%changelog
