%define module_name Math-3Space
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(Carp.pm) perl(Exporter.pm) perl(Exporter/Extensible.pm) perl(ExtUtils/MakeMaker.pm) perl(PDL.pm) perl(PDL/Lite.pm) perl(Scalar/Util.pm) perl(Test2/Suite.pm) perl(Test2/V0.pm) perl(XSLoader.pm) perl(overload.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.008
Release: alt1
Summary: 3D coordinate transformations made easy
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NE/NERDVANA/%{module_name}-%{version}.tar.gz

%description
This module implements the sort of 3D coordinate space math that would typically be done using
a 4x4 matrix, but instead uses a 3x4 matrix composed of axis vectors `xv', `yv', `zv'
(i.e. vectors that point along the axes of the coordinate space) plus an origin point.
This results in significantly fewer math operations needed to project points, and gives you a
more useful mental model to work with, like being able to see which direction the coordinate
space is "facing", or which way is "up".

The coordinate spaces track their the parent entry elsewhere in this document coordinate space, so you can perform advanced
projections from a space inside a space out to a different space inside a space inside a space
without thinking about the details.

The coordinate spaces can be exported as 4x4 matrices for use with OpenGL or other common 3D
systems.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md
%perl_vendor_archlib/M*
%perl_vendor_autolib/*

%changelog
