%define module_name Math-AnyNum
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(List/Util.pm) perl(Math/GMPq.pm) perl(Math/GMPz.pm) perl(Math/MPC.pm) perl(Math/MPFR.pm) perl(Module/Build.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.41
Release: alt1
Summary: Arbitrary size precision for integers, rationals, floating-points and complex numbers.
Group: Development/Perl
License: artistic_2
URL: https://github.com/trizen/Math-AnyNum

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TR/TRIZEN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
# Math-AnyNum

Arbitrary size precision for integers, rationals, floating-points and complex numbers.

# DESCRIPTION

[Math::AnyNum](https://metacpan.org/pod/Math::AnyNum) provides a correct, intuitive and transparent interface to the [GMP](https://gmplib.org/), [MPFR](http://www.mpfr.org/) and [MPC](http://www.multiprecision.org/) libraries, using [Math::GMPq](https://metacpan.org/release/Math-GMPq), [Math::GMPz](https://metacpan.org/release/Math-GMPz), [Math::MPFR](https://metacpan.org/release/Math-MPFR) and [Math::MPC](https://metacpan.org/release/Math-MPC).

# SYNOPSIS

```perl
use 5.014;
use Math::AnyNum qw(:overload factorial);

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE ignore.txt TODO Changes examples
%perl_vendor_privlib/M*

%changelog
