%define module_name Math-BigInt-Lite
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(Math/BigInt.pm) perl(Math/BigRat.pm) perl(Module/Signature.pm) perl(Scalar/Util.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.30
Release: alt1
Summary: What BigInts are before they become big
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PJ/PJACKLAM/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Math::BigInt is not very good suited to work with small (read: typical
less than 10 digits) numbers, since it has a quite high per-operation overhead
and is thus much slower than normal Perl for operations like:

_my $x = 1 + 2;____# fast and correct
_my $x = 2 ** 256;___# fast, but wrong

_my $x = Math::BigInt->new(1) + 2;_# slow, but correct
_my $x = Math::BigInt->new(2) ** 256;_# slow, and still correct

But for some applications, you want fast speed for small numbers without
the risk of overflowing.

This is were `Math::BigInt::Lite' comes into play.

Math::BigInt::Lite objects should behave in every way like Math::BigInt
objects, that is apart from the different label, you should not be able
to tell the difference. Since Math::BigInt::Lite is designed with speed in
mind, there are certain limitations build-in. In praxis, however, you will
not feel them, because everytime something gets to big to pass as Lite
(literally), it will upgrade the objects and operation in question to
Math::BigInt.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README CHANGES README.md BUGS TODO LICENSE
%perl_vendor_privlib/M*

%changelog
