%define module_name Math-DCT
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(Test2/Tools/Compare.pm) perl(Test2/Tools/Exception.pm) perl(Test2/V0.pm) perl(XSLoader.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt2
Summary: 1D and NxN 2D Fast Discreet Cosine Transforms (DCT-II)
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DK/DKECHAG/%{module_name}-%{version}.tar.gz

%description
An unscaled DCT-II implementation for 1D and NxN 2D in XS. For array sizes which
are a power of 2, a fast algorithm (FCT) described by Lee is used (with the addition
of a coefficient table that makes it even faster than some common implementations).

The module was written for a perceptual hash project that needed 32x32 DCT-II,
and on a 2.5GHz 2015 Macbook Pro over 11500/s per thread are processed. There is
currently no specifically optimized path for the common 8x8 DCT-II, so specialized
software will be faster for that (for reference, about 185000 8x8 transforms per
sec are achieved per thread on the same CPU using the dct2d function).

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_archlib/M*
%perl_vendor_autolib/*

%changelog
