# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Math-DWT-UDWT
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Pure Perl 1-D Undecimated Discrete Wavelet Transform.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KR/KROH/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module implements a pure Perl version of the 1-D Undecimated Discrete Wavelet Transform (UDWT), also known as the "stationary" Discrete Wavelet Transform, because it is shift-invariant.

Do not look here for efficiency - only implementation.  It is designed to be a reference for others who would like to see wavelets in action.  It is based off of MATLAB code from Ivan Selesnick's website at http://eeweb.poly.edu/iselesni/software/index.html.

    use Math::DWT::UDWT;

    # new object with Math::DWT::Wavelet::Symmlet module loaded
    # as wavelet; specifically, Symmlet5
    my $udwt = Math::DWT::UDWT->new('Symmlet',5);

    @signal=@signal[0..509];
    my $x = \@signal;  # can be any length - not just 2^n

    # performs one iteration of the UDWT on $x
    my $coeffs = $udwt->udwt($x);

    # notice how the UDWT returns more data than it took in
    # this is due to the linear convolution used right now.
    print scalar(@{$coeffs->[0]}); # 265
    print scalar(@{$coeffs->[1]}); # 265

    # test Perfect Reconstruction
    my $y=$udwt->iudwt($coeffs);

    my $maxerr=0;
    foreach my $i (0 .. scalar(@x)-1) {
        my $err = abs($x[$i] - $y->[$i]);
        $maxerr = $err if ($err > $maxerr);
    }
    print "$maxerr\n"; # prints 7.92255150372512e-12 (close to 0)
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/M*

%changelog
