%define module_name Math-Decimal128
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Math/BigInt.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt2
Summary: perl interface to C's _Decimal128 operations.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SI/SISYPHUS/%{module_name}-%{version}.tar.gz

%description
Math::Decimal128 supports up to 34 decimal digits of significand
   (mantissa) and an exponent range of -6143 to +6144.
   The smallest expressable value is
     -9.999999999999999999999999999999999e6144 which is also
   equivalent to
     -9.999999999999999999999999999999999e6111.
   The largest expressable value is
     9.999999999999999999999999999999999e6144 which is also
   equivalent to
     9.999999999999999999999999999999999e6111.
   The closest we can get to zero is (plus or minus) 1e-6176
   (which is also equivalent to
     1000000000000000000000000000000000e-6143).

   This module allows decimal floating point arithmetic via
   operator overloading - see "OVERLOADING".

   In the documentation that follows, "$mantissa" is a perl scalar
   holding a string of up to 16 decimal digits:
    $mantissa = '1234';
    $mantissa = '1234567890123456';

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_archlib/M*
%perl_vendor_autolib/*

%changelog
