Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Module/Build.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Math-Derivative
Version:        1.01
Release:        alt2_23
Summary:        Numeric 1st and 2nd order differentiation
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Math-Derivative
Source0:        https://cpan.metacpan.org/modules/by-module/Math/Math-Derivative-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  sed
# Run-time
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Tests
BuildRequires:  perl(Math/Utils.pm)
BuildRequires:  perl(Test/More.pm)
# Optional tests
# Test::CheckManifest not used
BuildRequires:  perl(Test/Pod.pm)
Source44: import.info


%description
This Perl package exports functions for performing numerical first
(Derivative1) and second Derivative2) order differentiation on vectors of
data. They both take references to two arrays containing the x and y
ordinates of the data and return an array of the 1st or 2nd derivative at
the given x ordinates. Derivative2 may optionally be given values to use
for the first derivative at the start and end points of the data -
otherwise 'natural' values are used.

%prep
%setup -q -n Math-Derivative-%{version}
# Convert EOL
sed -i 's/\r//' README

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc --no-dereference LICENSE
%doc README Changes
%{perl_vendor_privlib}/*

%changelog
