%define module_name Math-Float128
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Math/Trig.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Math-Float128
%define upstream_version 0.12

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    0.16
Release:    alt2

Summary:    Perl interface to C's (quadmath) __float128 operations
License:    perl
Group:      Development/Perl
Url:        http://metacpan.org/release/%{upstream_name}
Source0:    http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SI/SISYPHUS/%{module_name}-%{version}.tar.gz

BuildRequires: libquadmath0
BuildRequires: perl-devel
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl-devel
BuildRequires: libquadmath-devel
Source44: import.info

%description
   use Math::Float128 qw(:all);

   $arg = ~0; # largest UV
   $f1 = Math::Float128->new($arg); # Assign the UV ~0 to $f2.
   $f2 = UVtoF128($arg);            # Assign the UV ~0 to $f2.

   $arg = -21;
   $f1 = Math::Float128->new($arg); # Assign the IV -21 to $f2.
   $f2 = IVtoF128($arg);            # Assign the IV -21 to $f2.

%prep
%setup -q -n %{module_name}-%{version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%__make test

%install
%makeinstall_std

%files
%doc Changes README
%perl_vendor_archlib/*


%changelog
