# BEGIN SourceDeps(oneline):
BuildRequires: perl(Math/Polynomial.pm) perl(Module/Build/Tiny.pm) perl(Moo.pm) perl(Ouch.pm) perl(Path/Tiny.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_name Math-GF
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.004
Release: alt1
Summary: Galois Fields arithmetics
Group: Development/Perl
License: artistic_2
URL: https://github.com/polettix/Math-GF

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PO/POLETTIX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module allows you to generate and handle operations inside a Galois
Field (GF) of *any* allowed order:

=over

=item *

orders that are too big are likely to explode

=item *

orders that aren't prime number powers do not have associated Galois
Fields.

=back

It's easy to generate a new GF of a given order:

   my $GF5 = Math::GF->new(order => 5); # GF(5)
   my $GF8 = Math::GF->new(order => 8); # GF(2^3)

Since a GF of order *N* has exactly *N* elements, it's easy to refer to
them with integers from *0* to *N - 1*. If you want to actually
generate the associated element you can use the the e entry elsewhere in this document method:

   my $e5_gf8 = $GF8->e(5);

If you're planning to work extensively with a specific GF, or just want
some syntactic sugar, you can import a factory function in your package
that will generate elements in the specific GF:


   # by default, import a function named GF_p_n for GF(p^n)
   Math::GF->import_builder(8);
   my $e5 = GF_2_3(5);

   # you can give your name though
   Math::GF->import_builder(8, name => 'GF8');
   my $e5_gf8 = GF8(5);

If you need all elements, look at the the all entry elsewhere in this document method. It's the same as
doing this:

   my @all = map { $GF8->e($_) } 0 .. 8 - 1;

but easier to type and possibly a bit quicker.

Elements associated to *0* and *1* have the *usual* meaning of the
additive and multiplicative neutral elements, respectively. You can also
get them with the additive_neutral entry elsewhere in this document and the multiplicative_neutral entry elsewhere in this document.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README docs
%perl_vendor_privlib/M*

%changelog
