# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/gsl-config libgsl-devel perl(Alien/Role/Dino.pm) perl(Chart/Clicker.pm) perl(Chart/Clicker/Axis.pm) perl(Chart/Clicker/Data/DataSet.pm) perl(Chart/Clicker/Data/Series.pm) perl(Chart/Clicker/Decoration/Grid.pm) perl(Chart/Clicker/Decoration/Legend.pm) perl(Chart/Clicker/Decoration/Plot.pm) perl(Chart/Clicker/Renderer/Area.pm) perl(Class/Method/Modifiers.pm) perl(Math/Complex.pm) perl(Math/GSL/Alien.pm) perl(Module/Build.pm) perl(PkgConfig.pm) perl(Scalar/Util.pm) perl(Test/Class.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(Test/Taint.pm) perl(parent.pm) perl(version.pm) swig
# END SourceDeps(oneline)
%define module_name Math-GSL
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.49
Release: alt1
Summary: Interface to the GNU Scientific Library using SWIG
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HA/HAKONH/%{module_name}-%{version}.tar.gz

%description
use Math::GSL::Matrix;
    my $matrix = Math::GSL::Matrix->new(5,5);   # 5x5 zero matrix
    # note that columns and rows are zero-based
    $matrix->set_col(0, [1..5])                 # set *first* column to 1,2,3,4,5
           ->set_row(2, [5..9]);                # set *third* column to 5,6,7,8,9
    my @matrix = $matrix->as_list;              # matrix as Perl list
    my $gsl_matrix = $matrix->raw;              # underlying GSL object

    use Math::GSL::RNG;
    my $rng = Math::GSL::RNG->new;
    my @random_numbers = $rng->get(1000);

    use Math::GSL::Deriv qw/:all/;
    my $function = sub { my $x=shift; sin($x**2) };
    my ($status,$val,$err) = gsl_deriv_central($function, 5, 0.01 );

    use Math::GSL qw/gsl_version/;
    # get a version object for the version of the underlying GSL library,
    # which will stringify to a version number
    my $gsl_version = gsl_version();

Each GSL subsystem has its own module. For example, the random number generator
subsystem is Math::GSL::RNG. Many subsystems have a more Perlish and
object-oriented frontend which can be used, as the above example shows. The raw
GSL object is useful for using the low-level GSL functions, which in the case of
the Matrix subsystem, would be of the form gsl_matrix_* . Each module has further
documentation about the low-level C functions as well as using the more
intuitive (but slightly slower) object-oriented interface.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes CONTRIBUTING.md TODO README.md CREDITS examples
%perl_vendor_archlib/auto/*
%perl_vendor_archlib/M*

%changelog
