%define module_name Math-NV
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Math/MPFR.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.04
Release: alt2
Summary: assign correct value to perl's NV
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SI/SISYPHUS/%{module_name}-%{version}.tar.gz

%description
use Math::NV qw(:all);
   my $nv = nv('1e-298'); # ie the number 10 ** -298
   # or, in list context:
   my($nv, $iv) = nv('1e-298');

   The above snippet will assign a correct value for 1e-298 to $nv.
   Doing simply "$nv = 1e-298;" may *not* do that. (The test suite
   specifically checks and reports whether 1e-298 can correctly be
   assigned directly to a perl scalar. It also checks some other
   values).
   $iv is set to the number of characters in the input string that
   were unparsed.

   The nv() function assigns the value at the C (XS) level using
   either the C function strtod() or strtold() - whichever is 
   appropriate for your perl's configuration.

   Obviously, we are therefore relying upon absence of bugs in the
   way your compiler/libc assigns strings to floats. (Hopefully, if
   such bugs are present, this will become evident in the form of
   failures in the module's test suite.)

   NOTE:
    For an NV $nv, it's not guaranteed that nv($nv) and nv("$nv")
    will be equivalent. For example, on many of my 64-bit MS Win
    builds of perl, a print() of nv('1e-298') will output 1e-298,
    whereas a print() of nv(1e-298) outputs 9.99999999999999e-299.



%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_archlib/M*
%perl_vendor_autolib/*

%changelog
