%define module_name Math-Permutation
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0212
Release: alt1
Summary: pure Perl implementation of functions related to the permutations
Group: Development/Perl
License: mit
URL: https://github.com/E7-87-83/Math-Permutation

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CY/CYFUNG/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Math::Permutation;

    my $foo = Math::Permutation->cycles([[1,2,6,7], [3,4,5]]);
    say $foo->sprint_wrepr;
    # "2,6,4,5,3,7,1"

    my $bar = Math::Permutation->unrank(5, 19);
    $bar->comp($foo);
    say $bar->sprint_cycles;
    # (2 5 4 3)
    # Note that there is no canonical cycle representation in this module,
    # so each time the output may be slightly different.

    my $goo = Math::Permutation->clone($foo);
    say $goo->sprint_cycles;
    # (1 2 6 7) (4 5 3)

    $foo->inverse;
    say $foo->sprint_cycles;
    # (4 3 5) (1 7 6 2)

    $foo->comp($goo);
    say $foo->sprint_cycles;
    # ()

    say $bar->rank; # 19
    $bar->prev;
    say $bar->rank; # 18
    say $goo->rank; # 1264
    $goo->nxt;
    say $goo->rank; # 1265

    say $goo->is_even; # 0
    say $goo->sgn;     # -1

    use Data::Dump qw/dump/;
    say $bar->sprint_wrepr;
    dump $bar->matrix;

    # "1,4,5,3,2"
    # [
    #   [1, 0, 0, 0, 0],
    #   [0, 0, 0, 0, 1],
    #   [0, 0, 0, 1, 0],
    #   [0, 1, 0, 0, 0],
    #   [0, 0, 1, 0, 0],
    # ]

        
        

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/M*

%changelog
