%define module_name Math-Polynomial-Cyclotomic
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Math/BigInt.pm) perl(Math/Polynomial.pm) perl(Math/Prime/Util.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.004
Release: alt1
Summary: cyclotomic polynomials generator
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MH/MHASCH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This small extension of Math::Polynomial adds a constructor for cyclotomic
polynomials and a factoring algorithm for rational polynomials of the
form *x^n-1*.  Cyclotomic polynomials are monic irreducible polynomials
with integer coefficients that are a divisor of some binomial *x^n-1*
but not of any other binomial *x^k-1* with *k* < *n*.

=over 4

=item *cyclo_poly*

If `$n' is a positive integer number, `cyclo_poly($n)' calculates
the *n*th cyclotomic polynomial.

If `%%table' is a dictionary mapping indexes to previously computed
cyclotomic polynomials, `cyclo_poly($n, \%%table)' will do the same, but
use the table to store and look up intermediate results that also happen
to be cyclotomic polynomials.  The table must not contain other stuff,
nor should it be used for more than one coefficient type.  To be safe,
start with an empty hash but re-use it for similar calculations.

=item *Math::Polynomial::cyclotomic*

If `$poly' is a Math::Polynomial object and Math::Polynomial::Cyclotomic
has been loaded, `$poly->cyclotomic($n)' is essentially equivalent
to `cyclo_poly($n)', but returns a polynomial sharing the coefficient
type of `$poly'.

With an optional hashref argument for memoization,
`$poly->cyclotomic($n, \%%table)' will work similar to
`cyclo_poly($n, \%%table)'.

=item *cyclo_factors*

If `$n' is a positive integer number, `cyclo_factors($n)' calculates a
complete factorization of *x^n-1* over the field of rational numbers.
These are precisely the cyclotomic polynomials with index *k*, *k*
running through all positive integer divisors of *n*.  The factors are
ordered by increasing index, so that the *n*th cyclotomic polynomial
will be the last element of the list returned.

Like the cyclo_poly entry elsewhere in this document, *cyclo_factors* can be called with an optional
hashref argument for memoization.  It will store individual cyclotomic
polynomials, not complete factorizations, and can thus be used with
*cyclo_poly* and *cyclo_factors* interchangeably.

=item *Math::Polynomial::cyclo_factors*
...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CONTRIBUTING LICENSE README Changes examples
%perl_vendor_privlib/M*

%changelog
