# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Math/Symbolic.pm) perl(Math/SymbolicX/ParserExtensionFactory.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Math-Symbolic-Custom-ToShorterString
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.2
Release: alt1
Summary: Shorter string representations of Math::Symbolic trees
Group: Development/Perl
License: perl
URL: https://github.com/mjohnson108/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MJ/MJOHNSON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Provides `to_shorter_infix_string()' through the Math::Symbolic module extension class. "to_shorter_infix_string()" attempts to provide a string representation of a Math::Symbolic tree that is shorter and therefore more readable than the existing (infix) `to_string()' method. 

The "to_string()" method wraps every branch in parentheses/brackets, which makes larger expressions difficult to read. "to_shorter_infix_string()" tries to determine whether parentheses are required and omits them. One of the goals of this module is that the output string should parse to a Math::Symbolic tree that is (at least numerically) equivalent to the original expression - even if the resulting Math::Symbolic tree might not be completely identical to the original (for that, use "to_string()"). Where appropriate, it produces strings containing the Math::Symbolic parser aliases `sqrt()' and `exp()'.

From v0.2, the module uses the Math::SymbolicX::ParserExtensionFactory manpage to automatically add `ln(x)' as an alias for `log(e,x)' in the parser, and uses it for string output as well (in the same way as `sqrt()' and `exp()'). 

The "to_shorter_infix_string()" does not replace the "to_string()" method, it has to be called explicitly.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes ignore.txt README.md README examples
%perl_vendor_privlib/M*

%changelog
