# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Math-Vector-Real-MultiNormalMixture
%define upstream_version 0.02

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_10

Summary:    Multinormal Mixture distribution
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Math/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Math/Vector/Real.pm)
BuildArch: noarch
Source44: import.info

%description
This module allows to calculate the density of a mixture of n multivariate
normal symmetric distributions.

Given a multivariate normal symmetric distributions in IR**k (IR := the real
numbers domain) such that its density function can be calculated as...

  p($x) = (sqrt(2*pi)*$sigma)**(-$k) * exp(|$x-$mu|/$sigma)**2)

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes META.yml README
%perl_vendor_privlib/*




%changelog
