%define module_name Memorator
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/SQLite.pm) perl(Exporter.pm) perl(Minion.pm) perl(Module/Build/Tiny.pm) perl(Module/Runtime.pm) perl(Mojo/Base.pm) perl(Mojo/IOLoop.pm) perl(Path/Tiny.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Try/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.006
Release: alt1
Summary: Remind of events via Minion
Group: Development/Perl
License: artistic_2
URL: https://github.com/polettix/Memorator

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PO/POLETTIX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
=over

=over

=item *memor.'tor*

=over

=item *

imperative passive future of verb *memor.'re*, can be translated like
*you will be reminded* (see https://en.wiktionary.org/wiki/memoro,
expand section on *Inflection*).

=item *

nominative singular of *memor.'tor*, male third descension, can be
translated like *someone who mentions* (see
https://en.wiktionary.org/wiki/memorator)

=back

=back

=back

This module allows you to set alerts for some events you need to be warned
of. It's as simple as asking an alarm to ring at a certain date/time.

The module leverages on the Minion manpage for the heavylifting. It's actually
a thin API on top of it, installing two *tasks* which by default go under
the names `memorator_process_update' and `memorator_process_alert'
(although you can change the `memorator' part using the name entry elsewhere in this document).

The interaction model is simple:

=over

=item *

you create an object with an the alert_callback entry elsewhere in this document and a `minion' object
that will do the hard work. The the alert_callback entry elsewhere in this document is where you will
implement your logic for when the alert expires;

=item *

you enqueue *updates* to set new alarms or modify existing ones, based on
an *identifier* that is meaningful for you;

=item *

at the expiration of the alarm time, the the alert_callback entry elsewhere in this document is called with
the specific *identifier*, so that you can figure out what has to be done
next.

=back

To add a new reminder, or change an existing one, you use
`memorator_process_update' passing a hash reference like this:

   $minion->enqueue(memorator_process_update =>
      {
         eid => 'id-001',      # identifier meaningful for you
         epoch => (time + 30), # when you want the alert
         attempts => 5,        # how many retries before giving up
      }
   );

You can also set alerts directly, without the mediation of the Minion manpage,
using the set_alert entry elsewhere in this document:

   $memorator->set_a...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/M*

%changelog
