# "messages" pragma as a "Message::String" alias.
%filter_from_requires /^perl(messages.pm)/d
%filter_from_requires /^perl(message.pm)/d
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Capture/Tiny.pm) perl(Clone.pm) perl(Data/Dumper/Concise.pm) perl(DateTime.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Stty.pm) perl(List/MoreUtils.pm) perl(Sub/Util.pm) perl(Test/Deep.pm) perl(Test/Pod.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define module_name Message-String
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.9
Release: alt1
Summary: A pragma to declare and organise messaging.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CP/CPANIC/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The `Message::String' pragma and its alias (`message') are aimed at the
programmer who wishes to organise, identify, define, use (or make available
for use) message strings specific to an application or other message
domain. `Message::String' objects are not unlike constants, in fact, they
may even be used like constants; they're just a smidge more helpful.

Much of a script's lifetime is spent saying stuff, asking for stuff, maybe
even complaining about stuff; but, most important of all, they have to do
meaningful stuff, good stuff, the stuff they were designed to do.

The trouble with saying, asking for, and complaining about stuff is the
epic amount of repeated stuff that needs to be done just to do that kind
of stuff. And that kind of stuff is like visual white noise when it's
gets in the way of understanding and following a script's flow.

We factor out repetetive code into reusable subroutines, web content into 
templates, but we do nothing about our script's messaging. Putting up with
broken strings, quotes, spots and commas liberally peppered around the place
as we compose and recompose strings doesn't seem to bother us.

What if we could organise our application's messaging in a way that kept
all of that noise out of the way? A way that allowed us to access messages
using mnemonics but have useful, sensible and standard things happen when
we do so. This module attempts to provide the tooling to do just that.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE coverage.txt
%perl_vendor_privlib/M*

%changelog
