# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(GD.pm) perl(GD/Image.pm) perl(Image/ExifTool.pm) perl(Module/List.pm) perl(Statistics/Descriptive.pm) perl(Test/Deep.pm) perl(Test/Differences.pm) perl(Test/Group.pm) perl(Test/Harness.pm) perl(Test/Image/GD.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.45c
%define module_name Microarray
BuildRequires: unzip
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.45c
Release: alt1
Summary: A Perl module for creating and manipulating DNA Microarray experiment objects
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/C/CJ/CJONES/%module_name-%module_version.zip
BuildArch: noarch

%description
=begin html

<style type="text/css">	
	.thumb {
		margin-bottom: 0.5em;
		border-style: solid;
		border-color: white;
		width: auto;
		overflow: hidden;
	}
	.tright {
		float: right;
		clear: right;
		border-width: 0.5em 0 0.8em 1.4em;
	}
	.thumbinner {
		border: 1px solid #ccc;
		padding: 3px !important;
		background-color: #f9f9f9;
		font-size: 94%%;
		text-align: center;
		overflow: hidden;
	}
	.thumbimage {
		border: 1px solid #ccc;
	}
	.thumbcaption {
		border: none;
		text-align: left;
		line-height: 1.4em;
		padding: 3px !important;
		font-size: 90%%;
		font-style: italic;
	}
</style>
<div class="thumb tright">
	<div class="thumbinner" style="width:352px;">
		<img src="http://upload.wikimedia.org/wikipedia/commons/thumb/0/0e/Microarray2.gif/350px-Microarray2.gif" width="350" height="213" class="thumbimage" alt="Example of an approximately 40,000 probe spotted oligo microarray with enlarged inset to show detail">
		<div class="thumbcaption">
			Example of an approximately 40,000 probe spotted oligo microarray with enlarged inset to show detail
		</div>
	</div>
</div>

=end html

DNA Microarrays (http://en.wikipedia.org/wiki/Dna_microarray) also known as 'Gene Chips' or 'DNA chips', are an experimental tool used in genetic research and other related disciplines. They consist of thousands of DNA probes immobilised on a solid surface (such as a glass slide) and enable high-resolution, high-throughput analyses of a variety of parameters such as gene expression, genetic variation, or chromosome copy number variants. 


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/M*

%changelog
