%define module_name Minion-Notifier
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Mercury.pm) perl(Minion.pm) perl(Minion/Backend/SQLite.pm) perl(Module/Build/Tiny.pm) perl(Mojo/Pg.pm) perl(Mojo/Redis2.pm) perl(Mojo/SQLite.pm) perl(Mojolicious.pm) perl(Protocol/Redis.pm) perl(Scalar/Util.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt1
Summary: Notify listeners when a Minion task has completed
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JB/JBERGER/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Although the Minion manpage is a highly capable job queue, it does not natively have a mechanism to notify listeners when a job has finished or failed.
the Minion::Notifier manpage provides this feature using pluggable Transport backends.
Currently supported are Postgres, Redis, and WebSocket.
Postgres support requires the Mojo::Pg manpage and Redis requires the Mojo::Redis2 manpage.
WebSockets are native to Mojolicious but you need a broker to manage the connections; the Mercury manpage is the author's suggested WebSocket message broker.

Note that this is an early release and the mechansim for loading plugins, especially third-party plugins is likely to change.
Also note that due to the use of messaging buses, the order of events is not guaranteed especially on very fast jobs.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/M*

%changelog
