%define module_name Minions
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Digest/MD5.pm) perl(Exception/Class.pm) perl(Hash/Util.pm) perl(List/MoreUtils.pm) perl(Module/Build/Tiny.pm) perl(Module/Runtime.pm) perl(Package/Stash.pm) perl(Params/Validate.pm) perl(Readonly.pm) perl(Scalar/Util.pm) perl(Sub/Name.pm) perl(Test/Lib.pm) perl(Test/Most.pm) perl(Test/Output.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.000001
Release: alt1
Summary: What is I<your> API?
Group: Development/Perl
License: gpl
URL: https://github.com/arunbear/Minions

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AR/ARUNBEAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Minions is a class builder that makes it easy to create classes that are modular, which means
there is a clear separation between what end users need to know (the interface for using the class) and implementation details that users
don't need to know about.

Classes are built from a specification that declares the interface of the class (i.e. what commands minions of the classs respond to),
as well as a package that provide the implementation of these commands.

This separation of interface from implementation details is an important aspect of modular design, as it enables modules to be interchangeable (so long as they have the same interface).

It is not a coincidence that the Object Oriented concept as originally envisioned was mainly concerned with messaging,
where in the words of Alan Kay (who coined the term "Object Oriented Programming") objects are "like biological cells and/or individual computers on a network, only able to communicate with messages"
and "OOP to me means only messaging, local retention and protection and hiding of state-process, and extreme late-binding of all things."
(see The Deep Insights of Alan Kay).


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes
%perl_vendor_privlib/M*

%changelog
