Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(YAML.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-ModelSim-List
Version:        0.06
Release:        alt2_46
Summary:        Analyse the 'list' output of the ModelSim simulator

License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/ModelSim-List

Source0:        https://cpan.metacpan.org/authors/id/A/AG/AGENT/ModelSim-List-%{version}.tar.gz
Patch0:         ModelSim-List-0.06-Fix-building-on-Perl-without-dot-in-INC.patch

BuildArch:      noarch

BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(ExtUtils/MM_Unix.pm)
BuildRequires:  perl(File/Find.pm)
BuildRequires:  perl(File/Path.pm)
BuildRequires:  perl(FindBin.pm)
BuildRequires:  perl(Module/AutoInstall.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(vars.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  perl-devel
Source44: import.info


%description
This module provides a class named ModelSim::List with which the EDA tester
can easily check in the signals contained in the files generated by
ModelSim's "write list" command in a programming manner.

%prep
%setup -q -n ModelSim-List-%{version}
%patch0  -p1

# disable useless notice
sed "s|All rights reserved||" lib/ModelSim/List.pm > notice
touch -r lib/ModelSim/List.pm notice;
mv notice lib/ModelSim/List.pm

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install

make pure_install DESTDIR=$RPM_BUILD_ROOT

find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null \;

# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
