# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(IPC/Cmd.pm) perl(List/MoreUtils.pm) perl(Module/Build.pm) perl(Module/Build/Pluggable/Base.pm) perl(PDL.pm) perl(PDL/Core/Dev.pm) perl(PDL/PP.pm) perl(Path/Class.pm) perl(Pod/Perldoc.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name Module-Build-Pluggable-PDL
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.23
Release: alt1
Summary: Plugin to Module::Build to build PDL projets
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MG/MGRIMES/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is a plugin for the Module::Build manpage (using the Module::Build::Pluggable manpage)
that will assist in building the PDL manpage distributions. Please see the
the Module::Build::Authoring manpage documentation if you are not familiar with it.

=over 4

=item Add Prerequisites

    requires => { 'PDL' => '2.000' },
    build_requires => {
        'PDL'                => '2.000',
        'ExtUtils::CBuilder' => '0.23',
    },

You can, or course, require your own versions of these modules by adding them
to `requires =' {}> as usual. 

=item Process `.pd' files

The `lib' directory of your distribution will be searched for `.pd' files
and, immediately prior to the build phase, these will be processed by
`PDL::PP' into `.xs' and `.pm'. files as required to continue the build
process.  These will then be processed by `Ext::CBuilder' as normal. These
files are also added to the list of file to be cleaned up.

In addition, an entry will be made into `provides' for the `.pm' file of the
`META.json/yml' files. This will assist PAUSE, search.cpan.org and metacpan.org
in properly indexing the distribution and 

=item Generate `.pod' file from the `.pd'

When building the distribution (`./Build dist' or `./Build distdir'), any
`.pd' file found in the `lib' directory will converted into `.pod' files.
This produces a standalone version of the documentation which can be viewed
on search.cpan.org, metacpan.org, etc. When these sites attempt to display 
the pod in the `.pd' files directly, there is often formatting and processing
issues.

This is accomplished by first processing the files with `PDL::PP' and then
`perldoc -u'.

=item Add Include Dirs

    include_dirs => PDL::Core::Dev::whereami_any() . '/Core';

The `PDL/Core' directory is added to the `include_dirs' flag.

=item Add Extra Linker Flags

    extra_linker_flags =>  $PDL::Config{MALLOCDBG}->{libs}
      if $PDL::Config{MALLOCDBG}->{libs};

If needed, the MALLOCDBG libs will be added to the `extra_linker_flags'.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/M*

%changelog
