Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Tk.pm) perl(Tk/FcyEntry.pm) perl(Tk/Pod.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		perl-Module-Extract-VERSION
Version:	1.119
Release:	alt1_2
Summary:	Extract a module version without running code
License:	Artistic-2.0
URL:		https://metacpan.org/release/Module-Extract-VERSION
Source0:	https://cpan.metacpan.org/modules/by-module/Module/Module-Extract-VERSION-%{version}.tar.gz
BuildArch:	noarch
# Module Build
BuildRequires:	coreutils
BuildRequires:	rpm-build-perl
BuildRequires:	perl-devel
BuildRequires:	perl
BuildRequires:	perl(ExtUtils/MakeMaker.pm)
BuildRequires:	perl(File/Spec.pm)
BuildRequires:	perl(File/Spec/Functions.pm)
# Module Runtime
BuildRequires:	perl(Carp.pm)
BuildRequires:	perl(Safe.pm)
BuildRequires:	perl(strict.pm)
BuildRequires:	perl(version.pm)
BuildRequires:	perl(warnings.pm)
# Test Suite
BuildRequires:	perl(Test/More.pm)
# Optional Tests
BuildRequires:	perl(Test/Manifest.pm)
BuildRequires:	perl(Test/Pod.pm)
BuildRequires:	perl(Test/Pod/Coverage.pm)
# Dependencies
Requires:	perl(Safe.pm)
Requires:	perl(version.pm) >= 0.860
Source44: import.info

%description
This module lets you pull out of module source code the version number for the
module. It assumes that there is only one $VERSION in the file.

%prep
%setup -q -n Module-Extract-VERSION-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} -c %{buildroot}

%check
make test

%files
%doc --no-dereference LICENSE
%doc Changes README.pod SECURITY.md
%{perl_vendor_privlib}/Module/

%changelog
