# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(File/Find/Object.pm) perl(IO/All.pm) perl(Test/Run/CmdLine/Iface.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Module-Format
%define upstream_version 0.4.0

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_2

Summary:    Convert and manipulate stringified versions of Perl modules
License:    MIT
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Module/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(Getopt/Long.pm)
BuildRequires: perl(IO/Handle.pm)
BuildRequires: perl(IPC/Open3.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Pod/Usage.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(vars.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
Module-Format is a set of Perl modules and the accompanying perlmf command line
utility that can be used to output consistently-formatted names of Perl modules
for input in applications. So one can do:

urpmi --auto $(perlmf as_rpm_c "$@")

to install perl dependencies using urpmi (and many other uses).

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Build.PL --installdirs=vendor
./Build

%check
./Build test

%install
./Build install --destdir=%{buildroot}
perl -i -lpe 's{^(#\!/usr/bin/perl).*}{$1} if $. == 1' %{buildroot}/%{_bindir}/*

%files
%doc Changes LICENSE META.json META.yml  README
%{_bindir}/perlmf
%{_mandir}/man1/*
%{perl_vendor_privlib}/*


%changelog
