# BEGIN SourceDeps(oneline):
BuildRequires: perl(Module/Find.pm) perl(Module/Install/Base.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Module-Install-AggressiveInclude
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: A more aggressive include
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JM/JMMILLS/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
At times the Module::Install manpage's include() function may not be enough for you.
In that case the Module::Install::AggressiveInclude manpage may be what you need.

Often for local development I tend to shy away from installing packages I may
be working on so when working with packages that have multiple local
dependencies I find my self writing this Makefile.PL code a lot:

    # use lib for my local libraries somewhere around here
    # ...
    
    build_requires 'Module::Find';
    require Module::Find;
    
    include 'FooPackage';
    include $_ foreach Module::Find::findallmod 'FooPackage::*';
    
    # so on and so forth

Why? You may ask when the Module::Install manpage has a support for glob matching of
packages. Well, because for my (and maybe yours) it is not powerful enough
when it comes to deep includes.

For example say we have a lot of modules we want to include from the same
namespace:

    FooPackage
    FooPackage::Alpha
    FooPackage::Alpha::I
    FooPackage::Alpha::II
    FooPackage::Beta
    FooPackage::Beta::I
    FooPackage::Beta::II
    FooPackage::Gamma
    FooPackage::Gamma::I
    FooPackage::Gamma::II
    
If we use the Module::Install manpage's include function like this:

    include 'FooPackage::*';

Only these packages will get included:

    FooPackage::Alpha
    FooPackage::Beta
    FooPackage::Gamma
    # Not even plain ol' FooPackage is included

In my opinion this lacks some DWIM functionality.
So instead we do:

    include_aggressive 'FooPackage';

And we will get the base package as well as every class under it's namespace.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/M*

%changelog
