%define module_name Module-Lazy
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Warn.pm) perl(mro.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: postpone loading a module until it's actually used
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KH/KHEDIN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
In large projects loading all the dependencies may take a lot of time.
This module attempts to reduce the startup time by postponing initialization.
The improvement be significant for unit test scripts
and small command-line tools
which do not utilize all the functionality at once.

This comes at a cost of reduced stability,
as load-time errors are also postponed.
The `no Module::Lazy' directive is provided to mitigate the risk
by forcing the pending modules to load.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/M*

%changelog
