%define module_name Module-Load-In-INIT
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.005
Release: alt1
Summary: Load modules in INIT phase
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Module-Load-In-INIT

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module can load (or perhaps defer loading) modules in the INIT phase
instead of the BEGIN phase. One use-case where it is useful: monkey-patching a
module (using a the Module::Patch manpage-based module) in a fatpacked script (see
the Module::FatPack manpage or the App::FatPacker manpage), e.g.:

 %% perl -MSome::Module::Patch::Foo fatpacked-script.pl

`Some::Module::Patch::Foo' will try to load `Some::Module' then patch it. This
might fail when module is loaded by the fatpack handler (which is a require
hook) as by the time `Some::Module::Patch::Foo' is loaded, the fatpack handler
has not been setup yet, and `Some::Module' is not available elsewhere (on the
filesystem). This, however, works:

 %% perl -MModule::Load::In::INIT=Some::Module::Patch::Foo fatpacked-script.pl

Loading of `Some::Module::Patch::Foo' (and by extension, `Some::Module') is
deferred to the INIT phase. By that time, the fatpack require hook has been
setup and `Some::Module' can be (or might already be) loaded by it.

Caveat: Module::Load::In::INIT itself must be loaded in the BEGIN phase, or INIT
phase at the latest.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/M*

%changelog
