%define module_name Module-Path-More
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.340
Release: alt1
Summary: Get path to locally installed Perl module
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Module-Path-More

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Module::Path::More provides a function, `module_path()', which will find where
a module (or module prefix, or .pod file) is installed locally. (There is also
another function `pod_path()' which is just a convenience wrapper.)

It works by looking in all the directories in @INC for an appropriately named
file. If module is `Foo::Bar', will search for `Foo/Bar.pm', `Foo/Bar.pmc'
(if `find_pmc' argument is true), `Foo/Bar' directory (if `find_prefix'
argument is true), or `Foo/Bar.pod' (if `find_pod' argument is true).

Caveats: Obviously this only works where the module you're after has its own
`.pm' file. If a file defines multiple packages, this won't work. This also
won't find any modules that are being loaded in some special way, for example
using a code reference in `@INC', as described in `require' in the perlfunc manpage.

To check whether a module is available/loadable, it's generally better to use
something like:

 if (eval { require Some::Module; 1 }) {
     # module is available
 }

because this works with fatpacking or any other `@INC' hook that might be
installed. If you use:

 if (module_path(module => "Some::Module")) {
     # module is available
 }

then it only works if the module is locatable in the filesystem. But on the
other hand this method can avoid actual loading of the module.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/M*

%changelog
