%define module_version 0.002
%define module_name Module-Quote
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Module/Hash.pm) perl(PerlX/QuoteOperator.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators perl(Math/BigInt.pm)

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: a quote-like operator that requires modules for you
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Module-Quote

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
The `qm()' quote-like operator will load a module and return its name.
So the following should just work, even if you haven't `use'd
Math::BigInt in advance.

	qm( Math::BigInt 1.00 )->new(42)

The more usual invocation:

	Math::BigInt->new(42)

won't automatically load Math::BigInt, won't check a version number, and
crucially is ambiguous! (See what happens when you define a sub called
`BigInt' in the `Math' package.)

The `qm' operator interpolates variables, so this works too:

	my $x = "BigInt 1.00";
	qm( Math::$x )->new(42);

You may export `qm' with an alternative name:

	use Module::Quote 'qmod';

You may provide a hashref of options for the quote-like operator:

	use Module::Quote qm => { emulate => 'q' };

You can export the operator multiple times with different options:

	use Module::Quote
		qm  => { emulate => 'q' },
		qqm => { emulate => 'qq' },
	;

The `optimistic' and `prefix' options from the Module::Hash manpage are
supported. As is `emulate' which can be set to `"qq"' (the default)
or `"q"' (to disable interpolation).


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYRIGHT LICENSE Changes README
%perl_vendor_privlib/M*

%changelog
